// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.pay.echo.outbound.domain;

/**
 * Defines the echo request header sent to for the "/gsp/v1/echo" api.
 *
 * @see <a href=
 *     "https://developers.google.com/standard-payments/payment-integrator-diagnostic-api/rest/v2/TopLevel/echo#RequestHeader">
 *     Request Header </a>
 */
public class OutboundRequestHeader {

  private OutboundProtocolVersion protocolVersion;
  private String requestId;
  private String requestTimestamp;

  public OutboundRequestHeader(OutboundProtocolVersion protocolVersion, String requestId) {
    this.protocolVersion = protocolVersion;
    this.requestId = requestId;
    this.requestTimestamp = String.valueOf(System.currentTimeMillis());
  }

  public OutboundProtocolVersion getProtocolVersion() {
    return protocolVersion;
  }

  public void setProtocolVersion(OutboundProtocolVersion protocolVersion) {
    this.protocolVersion = protocolVersion;
  }

  public String getRequestId() {
    return requestId;
  }

  public void setRequestId(String requestId) {
    this.requestId = requestId;
  }

  public String getRequestTimestamp() {
    return requestTimestamp;
  }

  public void setRequestTimestamp(String requestTimestamp) {
    this.requestTimestamp = requestTimestamp;
  }
}
